#include "General.h"

#include "InfiniteAmmo.h"
#include "engine_weap.h"
#include "engine_tt.h"
#include "engine_io.h"
#include "gmgame.h"
#include "PhysicalGameObj.h"

#define WeaponDefID 0xB001
#define AmmoDefID 0xB002

#define STYLE_C4 0 // note that this list reflects the list in leveledit
#define STYLE_BEACON 6

void Enable_Infinite_Ammo() {
	WeaponDefinitionClass *Def = (WeaponDefinitionClass*)DefinitionMgrClass::Get_First(WeaponDefID);
	while (Def) {
		if (Def->Style != STYLE_C4 && Def->Style != STYLE_BEACON) {
			int NegOne = -1;
			Def->MaxInventoryRounds = NegOne;
		}
		Def = (WeaponDefinitionClass*)DefinitionMgrClass::Get_Next((DefinitionClass*) Def,WeaponDefID);
	}
}

DWORD WINAPI Set_Clip_Bullets_Infinite(LPVOID params)
{	
		Sleep(100);
		GameObject* obj = Get_GameObj((int)params);
		int Style = Get_Weapon_Style(obj, Get_Current_Weapon(obj));
		if (Style != STYLE_C4 && Style != STYLE_BEACON)
		{
			Set_Current_Clip_Bullets(obj, -1);
		}
		return 0;
}

void Purchase_Monitor_Hook(BaseControllerClass *base, GameObject *purchaser, unsigned int cost, unsigned int preset,unsigned int purchaseret,const char *data)
{
	if (purchaseret == 0)
	{
		CreateThread(NULL, NULL, Set_Clip_Bullets_Infinite, (LPVOID)Get_Player_ID(purchaser), NULL, NULL);
		//Set_Current_Bullets(purchaser, 900);
		//Set_Current_Clip_Bullets(purchaser, 900);
		//Grant_Refill(purchaser);
	}
}


InfiniteAmmo::InfiniteAmmo()
{
	RegisterEvent(EVENT_LOAD_LEVEL_HOOK,this);
	RegisterEvent(EVENT_OBJECT_CREATE_HOOK,this);
	AddVehiclePurchaseMonHook(Purchase_Monitor_Hook, "0");
	AddCharacterPurchaseMonHook(Purchase_Monitor_Hook, "1");
	AddPowerupPurchaseMonHook(Purchase_Monitor_Hook, "2");
}

InfiniteAmmo::~InfiniteAmmo()
{
	UnregisterEvent(EVENT_OBJECT_CREATE_HOOK,this);
	UnregisterEvent(EVENT_LOAD_LEVEL_HOOK,this);
}

void InfiniteAmmo::OnLoadLevel()
{
	Enable_Infinite_Ammo();
}

void InfiniteAmmo::OnObjectCreate(void *data,GameObject *obj)
{
	if (Commands->Is_A_Star(obj) && obj->As_SoldierGameObj())
	{
		Attach_Script_Once(obj,"Infinite_Ammo","");
	}

}

void Infinite_Ammo::Created(GameObject *obj)
{
	Commands->Start_Timer(obj,this,1,1);
}
void Infinite_Ammo::Timer_Expired(GameObject *obj,int number)
{
	if(number==1)
	{
		int Style = Get_Weapon_Style(obj, Get_Current_Weapon(obj));
		if (Style != STYLE_C4 && Style != STYLE_BEACON)
		{
			Set_Current_Clip_Bullets(obj, -1);
			Commands->Start_Timer(obj,this,1,1);
		}
	}
}
ScriptRegistrant<Infinite_Ammo> Infinite_Ammo_Registrant("Infinite_Ammo","");

InfiniteAmmo infiniteAmmo;

extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &infiniteAmmo;
}
